//Duobinary Encoding
//Windows 7
//Scilab 6.0.0

clc;
close;
//Note: Please run the xor.sci dependency file before executing this program
//Note: Don't run the clear command after running the dependency(xor.sci) as it contains the required funtion which will be cleared by the clear command 
b=[0 ,1 ,0 ,1 ,1 ,1 ,0]; // input binary sequence : precoder input
a(1)=xor_new(1,b(1));
if(a(1)==1)
a_volts(1)=1;
end
for k=2:length(b)
    a(k)=xor_new(a(k-1),b(k));
    if(a(k)==1)
        a_volts(k)=1;
    else
        a_volts(k)=-1;
    end
end
a=a';
a_volts=a_volts';
disp(a,'Pre coder output in binary form : ')
disp(a_volts,'Pre coder output in volts : ')

//Duobinary coder output in volts
c(1)=1+ a_volts(1);
for k =2:length(a)
    c(k)=a_volts(k -1)+a_volts(k);
end
c=c';
disp(c,'Duobinary coder output in volts : ')

//Duobinary decoder output by applying decision rule
for k =1:length(c)
    if(abs(c(k))>1)
        b_r(k)=0;
    else
        b_r ( k ) = 1;
    end
end
b_r=b_r';
disp(b_r,'Recovered original sequence at detector output :')

//Output
// Pre coder output in binary form : 
//
//   1.   0.   0.   1.   0.   1.   1.
//
// Pre coder output in volts : 
//
//   1.  -1.  -1.   1.  -1.   1.   1.
//
// Duobinary coder output in volts : 
//
//   2.   0.  -2.   0.   0.   0.   2.
//
// Recovered original sequence at detector output :
//
//   0.   1.   0.   1.   1.   1.   0.
